using System;
using System.Data;
using System.Data.SqlClient;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL
{

	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Mike      </Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>1/17/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>Data access component providing database access to rack data.</summary>

	#endregion

	public class Rack
	{
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1366"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable containing the list of racks</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1929"> 
		///		<ExpectedInput>Date 75 years in past</ExpectedInput>
		///		<ExpectedOutput>Conversion Exception</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		///	Gets the list of daily QC racks
		/// </summary>
		/// <param name="testDateTime"></param>
		/// <returns>DataTable containing list of daily QC racks</returns>
		public static DataTable GetDailyQCRacks(DateTime testDateTime)
		{
			SqlParameter[] prms =	
			{
				new SqlParameter(STOREDPROC.GetDailyQCRacks.divisioncode, System.Data.SqlDbType.VarChar),
				new SqlParameter(STOREDPROC.GetDailyQCRacks.testdatetime, System.Data.SqlDbType.DateTime)
			};

			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
			prms[1].Value = testDateTime;

			return StoredProcedure.GetData(STOREDPROC.GetDailyQCRacks.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/31/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1556"> 
		///		<ExpectedInput>Rack identifier and DailyUseIndicator</ExpectedInput>
		///		<ExpectedOutput>True</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1930"> 
		///		<ExpectedInput>Invalid RowVersion</ExpectedInput>
		///		<ExpectedOutput>RowVersionException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Updates rack daily use indicator
		/// </summary>
		/// <param name="dailyQcWorklistGuid">Daily Qc Worklist Guid</param>
		/// <param name="dailyUseIndicator">Daily use indicator</param>
		/// <param name="qcOfflineIndicator">QC Offline Indicator</param>
		/// <param name="lastUpdateFunctionId">UC or calling method</param>
		/// <param name="rowVersion">Row Version</param>
		/// <param name="rackGuid">rack Guid</param>
		/// <param name="dailyQcExpirationDateTime">daily qc expiration date time</param>
		/// <returns>True on success. Otherwise - false.</returns>
		public static bool UpdateRackDailyUse(Guid dailyQcWorklistGuid, bool dailyUseIndicator, bool qcOfflineIndicator, Common.UpdateFunction lastUpdateFunctionId, byte[] rowVersion, Guid rackGuid, DateTime dailyQcExpirationDateTime)
		{
			if (dailyQcWorklistGuid != Guid.Empty)
			{
				SqlParameter[] prms = null;

				prms = new SqlParameter[8];

				prms[0] = new SqlParameter(STOREDPROC.UpdateRackDailyUse.dailyqcworklistguid, System.Data.SqlDbType.UniqueIdentifier);
				prms[1] = new SqlParameter(STOREDPROC.UpdateRackDailyUse.dailyuseindicator, System.Data.SqlDbType.Bit);
				prms[2] = new SqlParameter(STOREDPROC.UpdateRackDailyUse.qcofflineindicator, System.Data.SqlDbType.Bit);
				prms[3] = new SqlParameter(STOREDPROC.UpdateRackDailyUse.lastupdatefunctionid, System.Data.SqlDbType.Int);
				prms[4] = new SqlParameter(STOREDPROC.UpdateRackDailyUse.lastupdateuser, System.Data.SqlDbType.VarChar);
				prms[5] = new SqlParameter(STOREDPROC.UpdateRackDailyUse.rowversion, System.Data.SqlDbType.Binary);
				prms[6] = new SqlParameter(STOREDPROC.UpdateRackDailyUse.dailyqcexpirationdate, System.Data.SqlDbType.DateTime);
				prms[7] = new SqlParameter(STOREDPROC.UpdateRackDailyUse.divisioncode, System.Data.SqlDbType.VarChar);

				prms[0].Value = dailyQcWorklistGuid;
				prms[1].Value = dailyUseIndicator;
				prms[2].Value = qcOfflineIndicator;
				prms[3].Value = (int)lastUpdateFunctionId;
				prms[4].Value = Common.LogonUser.LogonUserName;
				prms[5].Value = rowVersion;
				prms[6].Value = dailyQcExpirationDateTime;
				prms[7].Value = Common.LogonUser.LogonUserDivisionCode;

				return ((new StoredProcedure()).TransactionalGetValue(STOREDPROC.UpdateRackDailyUse.StoredProcName, prms) == 0);
			}
			else
			{
				SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.InsertDailyQcWorklist.dailyqcworklistguid, System.Data.SqlDbType.UniqueIdentifier),
					new SqlParameter(STOREDPROC.InsertDailyQcWorklist.RackGuid, System.Data.SqlDbType.UniqueIdentifier),
					new SqlParameter(STOREDPROC.InsertDailyQcWorklist.partiallytestedindicator, System.Data.SqlDbType.Bit),
					new SqlParameter(STOREDPROC.InsertDailyQcWorklist.dailyuseindicator, System.Data.SqlDbType.Bit),
					new SqlParameter(STOREDPROC.InsertDailyQcWorklist.qcofflineindicator, System.Data.SqlDbType.Bit),
					new SqlParameter(STOREDPROC.InsertDailyQcWorklist.divisioncode, System.Data.SqlDbType.VarChar),
					new SqlParameter(STOREDPROC.InsertDailyQcWorklist.lastupdatefunctionid, System.Data.SqlDbType.Int),
					new SqlParameter(STOREDPROC.InsertDailyQcWorklist.lastupdateuser, System.Data.SqlDbType.VarChar),
					new SqlParameter(STOREDPROC.InsertDailyQcWorklist.dailyqcexpirationdate, System.Data.SqlDbType.DateTime)
				};

				prms[0].Value = Guid.NewGuid();
				prms[1].Value = rackGuid;
				prms[2].Value = false;
				prms[3].Value = dailyUseIndicator;
				prms[4].Value = qcOfflineIndicator;
				prms[5].Value = Common.LogonUser.LogonUserDivisionCode;
				prms[6].Value = (int)lastUpdateFunctionId;
				prms[7].Value = Common.LogonUser.LogonUserName;
				prms[8].Value = dailyQcExpirationDateTime;

				return ((new StoredProcedure()).TransactionalGetValue(STOREDPROC.InsertDailyQcWorklist.StoredProcName, prms) == 0);
			}
		}

		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1512"> 
		///		<ExpectedInput>Daily Control GUID</ExpectedInput>
		///		<ExpectedOutput>A list of active racks for a given daily control</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1933"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the list of active daily QC racks for UC 51
		/// </summary>
		/// <param name="dailyControlGuid">Daily control GUID</param>
		/// <returns>
		///		A DataTable filled with rack data for active 
		///		racks that have been configured in UC 51
		/// </returns>
		public static DataTable GetConfigurableRackQC(System.Guid dailyControlGuid)
		{
			SqlParameter[] prms =	
			{
				new SqlParameter(STOREDPROC.GetConfigurableRackQC.divisioncode, System.Data.SqlDbType.VarChar),
				new SqlParameter(STOREDPROC.GetConfigurableRackQC.dailycontrolguid, System.Data.SqlDbType.UniqueIdentifier)
			};
			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
			prms[1].Value = dailyControlGuid;

			return StoredProcedure.GetData(STOREDPROC.GetConfigurableRackQC.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1518"> 
		///		<ExpectedInput>RackGuid</ExpectedInput>
		///		<ExpectedOutput>DataTable of Rack Details</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1529"> 
		///		<ExpectedInput>Invlaid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets Rack information for the RackGuid
		/// </summary>
		/// <param name="rackGuid"></param>
		/// <returns></returns>
		public static DataTable GetRack(System.Guid rackGuid)
		{
			SqlParameter[] prms =	
			{
				new SqlParameter(STOREDPROC.GetRack.RackGuid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetRack.divisioncode, System.Data.SqlDbType.Char)
			};

			prms[0].Value = rackGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetRack.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/25/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8095"> 
		///		<ExpectedInput>Valid dailyQcWorklistGuid</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8096"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get the date of the last qc for rack
		/// </summary>
		/// <param name="dailyQcWorklistGuid"></param>
		/// <returns></returns>
		public static DataTable GetRackTestDate(System.Guid dailyQcWorklistGuid)
		{
			SqlParameter[] prms =	
			{
				new SqlParameter(STOREDPROC.GetRackTestDate.dailyqcworklistguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetRackTestDate.divisioncode, System.Data.SqlDbType.VarChar)
			};

			prms[0].Value = dailyQcWorklistGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetRackTestDate.StoredProcName, prms).Tables[0];
		}

	}
}



